# Balanced Growth Root/Shoot C and P model, Version 4.7, May 15, 2008 (BalGroCP4.7)
# Eric Nord
# The initialization function, prep("input file name") must be run first. The model function, growo() runs the model, which is contained in the f.states() and f.rates() functions. Functions called by the model are named f.xxx. Vector varialbes are named v.xxx, and parameters are named p.xxx.  

# ------------------------
#calculate states [t] based on rates, states [t-1]

f.states=function(t){
		#add or overwrite row t to St
	St[t,]<<-rep(0,c.St) #add or overwrite row t to St
		# indices for new and old lf tissue. told= t at which lf tissue is old, newI ,old I are the vecotor indices for old and new tissue at t
	tnew<<-min(t-1,p.shtold);told<<-max(0,t-1-tnew) 
	newI<<-((told+1):(t-1));oldI<<-(0:told) 
	St$told[t]<<-told
		# seed C and P are accumulated from time t-1. Viable seed C&P, are the cumulative sum of the product of allocation to seed and probability of survival.
	St$sdC[t]<<-St$sdC[t-1]+Ra$sdCal[t-1]
	St$sdP[t]<<-St$sdP[t-1]+Ra$sdPal[t-1]
	St$vsdP[t]<<-St$vsdP[t-1]+(Ra$sdPal[t-1]*v.survival[t-1])
	St$vsdC[t]<<-St$vsdC[t-1]+(Ra$sdCal[t-1]*v.survival[t-1])
		# Rep C & P are accumulated from time t-1, and C&P are removed to seed
	St$repC[t]<<-St$repC[t-1]+Ra$repCal[t-1]-Ra$sdCal[t-1]
	St$repP[t]<<-St$repP[t-1]+Ra$repPal[t-1]-Ra$sdPal[t-1]
		# Root C&P and stem C&Pare accumulated from time t-1
	St$rtC[t]<<-St$rtC[t-1]+Ra$rtCal[t-1]
	St$rtP[t]<<-St$rtP[t-1]+Ra$rtPal[t-1]
	St$stmC[t]<<-St$stmC[t-1]+Ra$stmCal[t-1]
	St$stmP[t]<<-St$stmP[t-1]+Ra$stmPal[t-1]
		# lf C&P. n2olfC(P) is the amount of lfC(P) that moves from the new to the old class at t-1, which is the amount allocated to lfC(P) at told less any removed by senescence. newlfC(P) is then newlfC(P)at t-1 plus C(P) allocated to lf at t-1 less n2olfC(P). oldlfC(P) is oldlfC(p) at t-1 plus n2olfC less any removed by senescence of old tissue at t-1.
	n2olfC<-if (told==0){0}else{Ra$lfCal[told]-sum(Ra$lfCrealn[(t-2):(told+1)])/p.shtold}
	n2olfP<-if (told==0){0}else{Ra$lfPal[told]-sum(Ra$lfPrealn[(t-2):(told+1)])/p.shtold}
	St$newlfC[t]<<-Ra$lfCal[t-1]+St$newlfC[t-1]-Ra$lfCrealn[t-1]-n2olfC 
	St$oldlfC[t]<<-St$oldlfC[t-1]+n2olfC-Ra$lfCrealo[t-1]
	St$newlfP[t]<<-Ra$lfPal[t-1]+St$newlfP[t-1]-Ra$lfPrealn[t-1]-n2olfP
	St$oldlfP[t]<<-St$oldlfP[t-1]+n2olfP-Ra$lfPrealo[t-1]
		#extra C(P)- uptake of C+reallocated C+extraCat t-1 less maint. resp -growth resp. - C allocated to rt, lf, rep. These are used in calculation the available C and P for allocation to growth.
	St$Cextra[t]<<-Ra$Cfix[t-1]+St$Cextra[t-1]+Ra$lfCrealo[t-1]+Ra$lfCrealn[t-1]- (Ra$rtmres[t-1]+Ra$stmmres[t-1]+Ra$lfmres[t-1]+Ra$repmres[t-1])- (Ra$rtgres[t-1]+Ra$shtgres[t-1]+Ra$repgres[t-1])-(Ra$rtCal[t-1]+ Ra$stmCal[t-1]+Ra$lfCal[t-1]+Ra$repCal[t-1])
	St$Pextra[t]<<-Ra$Pup[t-1]+St$Pextra[t-1]+Ra$lfPrealo[t-1]+Ra$lfPrealn[t-1]-(Ra$rtPal[t-1]+ Ra$stmPal[t-1]+Ra$lfPal[t-1]+Ra$repPal[t-1])
		#CPal is the ratio of C:P allocated to growth at t-1. used in the allocation calculations in the rates() function.
	St$CPal[t]<<-(Ra$repCal[t-1]+Ra$rtCal[t-1]+Ra$stmCal[t-1]+Ra$lfCal[t-1])/ (Ra$repPal[t-1]+Ra$rtPal[t-1]+Ra$stmPal[t-1]+Ra$lfPal[t-1])
		# C(P)total calculates the total C in tissues. These are used by the error checking calculations that follow them, which make sure C(P)are conserved.
	St$Ctotal[t]<<-St$rtC[t]+St$stmC[t]+St$newlfC[t]+St$oldlfC[t]+St$repC[t]+ St$sdC[t]+St$Cextra[t]
	St$Ptotal[t]<<-St$rtP[t]+St$stmP[t]+St$newlfP[t]+St$oldlfP[t]+St$repP[t]+ St$sdP[t]+St$Pextra[t]
	if(abs(St$Ctotal[t]-St$Ctotal[t-1]-Ra$Cfix[t-1]+(Ra$rtmres[t-1]+ Ra$stmmres[t-1]+Ra$lfmres[t-1]+Ra$repmres[t-1])+(Ra$rtgres[t-1]+Ra$shtgres[t-1]+ Ra$repgres[t-1]))>=(St$Ctotal[t]/100000)){ERR<<-paste(t,"cbal")}
	if(abs(St$Ptotal[t]-St$Ptotal[t-1]-Ra$Pup[t-1])>=(St$Ptotal[t]/100000)) {ERR<<-paste(t,"pbal")}
	} #end states()
# ----------------------------------
#calculate rates - using only time[t], so order may matter

f.rates=function(t){
	#add or overwrite row t to Ra
	Ra[t,]<<-rep(0,c.Ra)
	#maintenance resp. this is the size of the pool * maintenance respiration rate. Fol lf tissue we assume that respiration rate declines from p.lfmr to some fixed proportion of p.lfmr at told (a smoother function would be better.)
	Ra$repmres[t]<<-St$repC[t]*p.repmr
	Ra$rtmres[t]<<-St$rtC[t]*p.rtmr
	Ra$stmmres[t]<<-St$stmC[t]*p.stmmr
	# moved down to line 72 Ra$lfmres[t]<<-(St$newlfC[t]*p.lfmr) +(St$oldlfC[t]*p.lfmr*p.oldlfmr)
		#Reallocation from old leaves. Carry forward senrate (Ra$srt)from  t-1. lfCrealo (old tissue) is the product of srt and oldlfC-non reallocatable  pool.
	Ra$srt[t]<<-Ra$srt[t-1]
	Ra$lfCrealo[t]<<-max(0,Ra$srt[t]*(St$oldlfC[t]-sum((Ra$lfCal*p.lffix)[oldI])))
	Ra$lfPrealo[t]<<-max(0,Ra$srt[t]*(St$oldlfP[t]-sum((Ra$lfPal*p.lffix)[oldI])))
		#Reallocation from new leaves (programmed or forced) is similar, but uses the the senrate from the matrix v.senrate, which is 0 until reproduction is inititated.  Last calculation is an error check.
	Ra$lfCrealn[t]<<-max(0,v.senrate[t]*(St$newlfC[t]-sum((Ra$lfCal*p.lffix)[newI])))
	Ra$lfPrealn[t]<<-max(0,v.senrate[t]*(St$newlfP[t]-sum((Ra$lfPal*p.lffix)[newI])))
	if(Ra$lfCrealo[t]<0|Ra$lfPrealo[t]<0|Ra$lfCrealn[t]<0|Ra$lfPrealn[t]<0){ERR<<-paste(t,"-realloc")}
		#In order to calculate C fixation, we need to know how much lfC is in each age class (day), as C fixation depends on the amount of tissue in each age class and the efficiency of tissue of that age. lCrn is a matrix of the amount of C reallocated from new leaf tissue. Rows represent tissue age from t-1 to told, and cols represent time from t backward. for each time, lfCrealn is divied by p.shtold, and this value stored in the first column of the matrix. Row sums are used in the calculation of Cfix.
	if(Ra$lfCrealn[t]>0){
		lCrn<<-rbind(rep(0,p.shtold),lCrn); lCrn<<-lCrn[-c(p.shtold),]
		lCrn<<-cbind(rep(Ra$lfCrealn[t]/p.shtold,p.shtold),lCrn)
		lCrn<<-lCrn[,-c(p.shtold)];LCRS<<-rowSums(lCrn)
		}
		# C fixation is a function of Cavail and the mass and C fixation efficiency of tissue in each age class. Cint is the C available for respiration and growth.
	Ra$lfmres[t]<<-p.lfmr*sum((Ra$lfCal[newI]-LCRS[tnew:1])* (v.shteff[length(newI):1]*(1-p.oldlfmr)+p.oldlfmr)) + (St$oldlfC[t]*p.lfmr*p.oldlfmr)
	melc<-(3.14159*p.mcr^2*0.376/0.3426)*sum((1-0.65)^(0:(p.maxLAI-1)))
	Ra$Cfix[t]<<-p.Cavail*min(melc,(sum((Ra$lfCal[newI]-LCRS[tnew:1])*v.shteff [length(newI):1])+p.shteffmin*St$oldlfC[t]))+(St$repC[t]*p.rshteff*p.Cavail)
	Ra$Cint[t]<<-Ra$Cfix[t]+Ra$lfCrealo[t]+Ra$lfCrealn[t]+St$Cextra[t]- (Ra$rtmres[t]+ Ra$stmmres[t]+Ra$lfmres[t]+Ra$repmres[t])
		# When C fixation isn't sufficient to supply respiration demand,force increased senescence. First calculate the extra C demand (xCreal). Increase senrate of old tissue first, then calculate the required increase in senrate (srxo), and increase the senrate by srxo, and recalculate oldleaf senescence.
		if (Ra$Cint[t]<0){
			xCreal<-1.005*-Ra$Cint[t]  #  the 1.005 is so Cint>0
			srxo<- max(0,min(p.maxsr-Ra$srt[t],xCreal/(St$oldlfC[t]-sum((Ra$lfCal*(1-p.lffix))[oldI])))) #xtra sen of old tissue, can't be>maxsr
			Ra$srt[t]<<-min(p.maxsr,Ra$srt[t]+srxo)
			lfCrealo<-max(0,Ra$srt[t]*(St$oldlfC[t]-sum((Ra$lfCal*p.lffix)[oldI])))
			xlfCrealo<-lfCrealo-Ra$lfCrealo[t]
			Ra$lfCrealo[t]<<-lfCrealo
			Ra$lfPrealo[t]<<-max(0,Ra$srt[t]*(St$oldlfP[t]-sum((Ra$lfPal*p.lffix)[oldI])))
			xCreal<-xCreal-xlfCrealo
		## if old tissue isn't enough, increase senrate for new tissue too - the calculation mirror those above
			if (xCreal>0){
				srxn<- max(0,min(p.maxsr-v.senrate[t],xCreal/(St$oldlfC[t]-sum((Ra$lfCal*(1-p.lffix))[oldI]))))
				v.senrate[t:p.maxtime]<<-min(p.maxsr,v.senrate[t]+srxn)
				Ra$lfCrealn[t]<<-max(0,v.senrate[t]*(St$newlfC[t]-sum((Ra$lfCal*p.lffix)[newI])))
				Ra$lfPrealn[t]<<-max(0,v.senrate[t]*(St$newlfP[t]-sum((Ra$lfPal*p.lffix)[newI])))
				lCrn[,1]<<-rep(Ra$lfCrealn[t]/p.shtold,p.shtold)
				} # end new tiss forced senescence, recalculate Cint 
			Ra$Cint[t]<<-Ra$Cfix[t]+Ra$lfCrealo[t]+Ra$lfCrealn[t]+St$Cextra[t]-(Ra$rtmres[t]+ Ra$stmmres[t]+Ra$lfmres[t]+Ra$repmres[t]) 			} # end increased senescence calcs
		# P uptake is a function of Pavail and the mass and P uptake efficiency of roots  in each age class. Pint is the P available for respiration and growth.
	Ra$Pup[t]<<-sum(Ra$rtCal[(t-1):1]*v.rteff[1:(t-1)])*p.Pavail #* make fn of RL
	Ra$Pint[t]<<-Ra$Pup[t]+Ra$lfPrealo[t]+Ra$lfPrealn[t]+St$Pextra[t]
		# an error check to make sure Cint, P int don't go negative
	if(Ra$Cint[t]<0|Ra$Pint[t]<0){ERR<<-paste(t,"-Cint(Pint)")}
		# allocation proportions are based on IRR,  the internal resource ratio (which is Cint/Pint, but P int is scaled in units of C by the ratio of C:P allocated at t-1). repprop is a function of time, determined by the v.alrep vector.
	Ra$IRR[t]<<-(Ra$Cint[t])/(Ra$Pint[t]*St$CPal[t])
	Ra$repprop[t]<<-v.alrep[t]
	Ra$rtprop[t]<<-(1-v.alrep[t])*Ra$IRR[t]/(Ra$IRR[t]+(1/Ra$IRR[t]))
	Ra$shtprop[t]<<-(1-v.alrep[t])*(1/Ra$IRR[t])/(Ra$IRR[t]+(1/Ra$IRR[t]))
		# error checks to make sure proportions are positive and sum to 1.
	if(abs(1-Ra$repprop[t]-Ra$rtprop[t]-Ra$shtprop[t])>=0.000001) {ERR<<-paste(t,"prop")}
	if((Ra$repprop[t]<0)|(Ra$rtprop[t]<0)|(Ra$shtprop[t]<0)) {ERR<<-paste(t,"prop-")}
		#C  and P allocation - this is calculated using the proportions calculated above, and is determined by C and P available and the C:P ratio required for the tissue
	Ra$repCal[t]<<-min(Ra$Cint[t]/(1+p.grresrate), Ra$Pint[t]*p.repCPratio)*Ra$repprop[t]
	### Ra$repCal[t]<<-min(Ra$repCal[t], p.MaxrepGR)
	Ra$rtCal[t]<<- min(Ra$Cint[t]/(1+p.grresrate), Ra$Pint[t]*p.rtCPratio) *Ra$rtprop[t]
	Ra$stmCal[t]<<-min(Ra$Cint[t]/ (1+p.grresrate), Ra$Pint[t]*p.stmCPratio) *Ra$shtprop[t]*p.stemprop
	Ra$stmCal[t]<<- min(Ra$stmCal[t],p.MSGR*(p.stemprop)) # enforce MSGR
	Ra$lfCal[t]<<-min(Ra$Cint[t]/(1+p.grresrate), Ra$Pint[t]*p.lfCPratio) *Ra$shtprop[t]*(1-p.stemprop)
	Ra$lfCal[t]<<- min(Ra$lfCal[t],p.MSGR*(1-p.stemprop)) # enforce MSGR
	Ra$sdCal[t]<<-if(t>(p.daysd+1)){(Ra$repCal[t-p.daysd-1]*p.repeff)}else{0}
	Ra$repPal[t]<<-min(Ra$Pint[t], Ra$Cint[t]/(1+p.grresrate)/p.repCPratio)* Ra$repprop[t]
	###Ra$repPal[t]<<-min(Ra$repPal[t],p.MaxrepGR/p.lfCPratio) # enforce MRGR
	Ra$rtPal[t]<<-min(Ra$Pint[t], Ra$Cint[t]/(1+p.grresrate)/p.rtCPratio)* Ra$rtprop[t]
	Ra$stmPal[t]<<-min(Ra$Pint[t], Ra$Cint[t]/(1+p.grresrate)/p.stmCPratio)* Ra$shtprop[t]*p.stemprop
	Ra$stmPal[t]<<-min(Ra$stmPal[t],p.MSGR/p.lfCPratio*(p.stemprop)) # enforce MSGR
	Ra$lfPal[t]<<- min(Ra$Pint[t], Ra$Cint[t]/(1+p.grresrate)/p.lfCPratio)* Ra$shtprop[t]*(1-p.stemprop)
	Ra$lfPal[t]<<-min(Ra$lfPal[t],p.MSGR/p.lfCPratio*(1-p.stemprop)) # enforce MSGR
	Ra$sdPal[t]<<-if(t>(p.daysd+1)){(Ra$repPal[t-p.daysd-1]*p.repeff)}else{0}
		#growth respiration
	Ra$repgres[t]<<-Ra$repCal[t]*p.grresrate
	Ra$rtgres[t]<<-Ra$rtCal[t]*p.grresrate
	Ra$shtgres[t]<<-(Ra$stmCal[t]+Ra$lfCal[t])*p.grresrate
		# Error checks for negative allocations.
	if((Ra$repCal[t]<0)|(Ra$rtCal[t]<0)|(Ra$stmCal[t]<0 | Ra$lfCal[t]<0)) {ERR<<-paste(t,"cal-")}
	if((Ra$repPal[t]<0)|(Ra$rtPal[t]<0)|(Ra$stmPal[t]<0 | Ra$lfPal[t]<0)) {ERR<<-paste(t,"pal-")}
		#C and P to seed
	} #end rates()
# ----------------------------------------
# prep() runs f.input() and initializes most of the vectors needed to run the model
prep=function(file="4.6 ArabiLPIF.txt"){ #run before optim
	f.input(file)
	Ra$srt[1]<<-p.senrate
	d<<-p.maxtime
	v.survival<<-f.survive(d)
	v.rteff<<-f.rootefficiency(p.rteffmin,p.rteffmintime,d)
	v.shteff<<-f.shootefficiency(p.shteffmin,p.shteffhalf,p.shteffsteep,d)
	p.shtold<<-min(which(v.shteff<(p.lfmr/p.Cavail)))
	}
# ---------------------------------------
# growo() The main function of the model.
# prep()must be run before growo() is first invoked. 
# model plant growth from B to E with reproduction beginning at inirep, vegeatative growth ending at termveg, and senescence beginning no later than agsen
growo=function(B,E,inirep,termveg,agsen){
	if (termveg > (inirep + p.lim)){return(c(0,0))} # limit termveg
	if (p.senb4rep < 1) {if (agsen < inirep){return(c(0,0))}} # limit agsen
		# initialize the lCrn matrix (must be calculated each time growo is run) 
	lCrn<<-matrix(rep(0,p.shtold^2),p.shtold,p.shtold);LCRS<<-rep(0,p.shtold)
	B<-min(B,nrow(St)+1,nrow(Ra)+1) # B can't be > than nrow(Ra,St)+1 
	# B < day of new leaf reallocatio
	B<-min(B,suppressWarnings(min(which(Ra$lfCrealn>0)))-1) 
	if(is.na(B)|B<2){B<-2};bug<<-c(B,E)
			# once B has been adjusted, remove any rows of Ra, St > B-1
	if (exists("St") & nrow(St)>=B){St<<-St[-c((B):nrow(St)),]}
	if (exists("Ra") & nrow(Ra)>=B){Ra<<-Ra[-c((B):nrow(Ra)),]}
		# load the growo parameters into the p.xx names
	p.inirep<<-inirep
	p.termveg<<-termveg
	p.agsen<<-agsen
		# run the alrep and senrate functions to create the respective vectors.
	v.alrep<<-f.alrep(p.inirep, p.termveg,E) * p.repmax
	v.senrate<<-f.senrate(p.agsen,p.senrate,E)
	ERR<<-0 # clear the error counter
		# loop through states and rates calculations
	for (t in B:E){
		if(ERR!=0){if(length(St$vsdP)>t){St$vsdC[(t+1):length(St$vsdC)]<<-0}
			break}else{
			f.states(t);f.rates(t)
			}# loop will break when an error is stored
		} # end time loop
			# return the max value of vsdP and the time at which this occured (plant "death"day)
		return(c(max(St$vsdC),max(which(St$vsdC == max(St$vsdC, na.rm=TRUE)))))
	} #end grow()

# ------------------------------------
# f.input reads parameters and initial values from input file.
# NB! "inputfile" MUST be in WD & WD must be set correctly or path must be specified
# input file conventions: p.* = parameter, s.* = state, r.* = rate. # are comments and are ignored. Order of items in input file does not matter, but the format for each line must be: variable name <tab> value <tab> any notes or comments

f.input=function(file="4.6 ArabiLPIF.txt"){ 
	rm(list=ls(.GlobalEnv,pattern="^p\\."),inherits=T) #clear variables from previous runs
	suppressWarnings(rm(list=c("Ra","St","c.St","c.Ra")))
	suppressWarnings(rm(list=c("newI","oldI","tnew","told","lCrn","LCRS")))
		# Read Input File and set parameters and initial conditions
	v.input <<-read.table(file,header=T,sep = "\t",na.strings = ".") # Read Input File 
	for(i in 1:length(v.input[,1])){ # loop through v.input and assign values to variable names
	nam<-toString(v.input[i,1]);assign(nam,v.input[i,2], env=.GlobalEnv);
		}
		# Define matrices of rates and states 
	A<-(ls(.GlobalEnv,pattern="^r\\.")) # collect all rates
	Ra<<-matrix(0,length(get(A[1])),length(A))
	for(i in 1:length(A)){Ra[,i]<<-get(A[i])}
	Ra<<-data.frame(Ra); A=sub("^r\\.","",A);names(Ra)<<-A
	B<-(ls(.GlobalEnv,pattern="^s\\.")) # collect all states
	St<<-matrix(0,length(get(B[1])),length(B))
	for(i in 1:length(B)){St[,i]<<-get(B[i])}
	St<<-data.frame(St);B=sub("^s\\.","",B); names(St)<<-B
	rm(list=ls(.GlobalEnv,pattern="^r\\."),inherits=T); rm(list=ls(.GlobalEnv,pattern="^s\\."),inherits=T) #remove r.* and s.*
	c.Ra<<-ncol(Ra);c.St<<-ncol(St)
	} #end f.input()
# -----------------------
# -----------------------
# calculate the vector of proportion of resource allcoated to reproduction for each time. This vector is zero until the time p.inirep, and then increases linearly until time p.termveg.
f.alrep=function(p.inirep,p.termveg,d){ 
	alreptemp<-rep(0,d)
	step<-1/(p.termveg-p.inirep+1)
	for(i in 1:d){
		if(i >= p.inirep & i < p.termveg){alreptemp[i]=alreptemp[i-1]+step}
		if(i >= p.termveg){alreptemp[i]=1}
		}; return(alreptemp); } #end alrep()
# -----------------------
# calculate the vector of senescence rate for each time.
f.senrate=function(p.agsen,p.senrate,n){ 
	senratetemp=rep(0,n); for(i in 1:n){
		if(i >= p.agsen){senratetemp[i]=p.senrate}
		}; return(senratetemp);	} #end senrate()
# ----------------------
# calculate the vector of root efficiency for each root age. asymptotic decline to within a tolerance of min at mintime
f.rootefficiency=function(p.rteffmin,p.rteffmintime,d){ 
	rteff=rep(0,d)
	tol<-(1/(p.rteffmin*100)) #previously I used 0.05 for tol, but this is better - large min values -> small tol values, which is what we want
	for(i in  1:d){
		rteff[i]=p.rteffmin+(1-p.rteffmin)* ((p.rteffmin*tol)/(1-p.rteffmin))^((i-1)/(p.rteffmintime-1))}

	return(rteff);} #end root efficiency
# -----------------------
# calculate the vector of leaf efficiency for each leaf tissue age.logistic decay to minimum with steepenss and halfmax 
f.shootefficiency=function(p.shteffmin,p.shteffhalf,p.shteffsteep,d){	#maxi <- 1-(exp(p.shteffsteep*(1-p.shteffhalf))/(1+exp(p.shteffsteep*(1-p.shteffhalf)))*(1-p.shteffmin))
	shteff <- rep(0,d)
	for(i in  1:d){
		shteff[i] <- p.shteffmin+(1-p.shteffmin)*(exp(-p.shteffsteep*(i-p.shteffhalf))/(1+exp(-p.shteffsteep*(i-p.shteffhalf))))}
		#shteff[i] <- (1-(exp(p.shteffsteep*(i-p.shteffhalf))/(1+exp(p.shteffsteep*(i-p.shteffhalf)))*(1-p.shteffmin)))/maxi}
	return(shteff);} #end shoot efficiency	
# -----------------------
#calculate the vector of probability of survival at each time. This is basically logistic, but we "clip" the lower 120 days of a greater logistic curve, so it can be somewhat assymetrical, depending on where the half max is set.
# y=(EXP(g*(x-d))/(1+EXP(g*(x-d))))*((1+EXP(g*(t.1-d)))/(EXP(g*(t.1-d))))

survive=function(d){ # calculates probability of survivorship vector
	survival=0
	B=(1+exp(p.MRp1*(p.maxtime-p.MRp2)))/(exp(p.MRp1*(p.maxtime-p.MRp2)))
	for (i in 1:d){
		A=exp(p.MRp1*(i-p.MRp2))/(1+exp(p.MRp1*(i-p.MRp2)))
		survival[i]=1-A*B	}
	return(survival)
	} #end survive()
# -----------------------
# optimize(grow,c(p.inirep,p.maxtime),maximum=FALSE,tol=0.0001)
# optim(p,grow,gr=NULL,method="L-BFGS-B",lower=c(10,0.05,10),upper=c(120,1,120))
# optimize() and optim() DON'T WORK here b/c I can't get them to treat my time variables as integer values....
# optgrid() {he.R.misc} uses an ndimensional grid seach which is slow, ineeficient, and dumb, but it seems to handle integer variables OK
# genoud() is a genetic algorithm optimizer which might work also
# optimization tools for BalGroCP4.7
# -----------------------	
# optCP() is my smartest optimizer - hopefully faster than optallCP(). Find optimal timing of reproduction and senescence. The search region (early:late) is divided into  nsteps regions (default = 5), and these are tested. The local area around the best of each of these is then tested at higher resolution. prep() must be run first to load inputs. In general, if the interval I:L is large, nsteps should be larger for greater speed.

optCP=function(early,late,nsteps=9){
	I<-early; L<-late; Au<-L; Al<-I	# set Au, Al, upper and lower A limits
	Bu<-L;Bl<-I
	size<-length(I:L) # create matrices to store results and optimal senence time
	optres  <<-matrix(data=NA,nrow=size,ncol=size,dimnames=list(I:L,I:L))
	optagsen<<-matrix(data=NA,nrow=size,ncol=size,dimnames=list(I:L,I:L))
	optspan<<-matrix(data=NA,nrow=size,ncol=size,dimnames=list(I:L,I:L))
	optB<<-matrix(data=0,nrow=1,ncol=3)
	step<-trunc((L-I)/nsteps) #divide interval L:I into nsteps steps
	growo(2,I,I,I,I) #run fr t=2 - I for initial population of Ra, St
	itcount<<-1
	if (step >=2) { # skip inirep loop 1 if step<2
		for (a in seq(L,I,-step)){ # inirep loop 1
			B2lim<-bestb(I,L,L,a,a,nsteps,step) # find the best termveg | inirep
			optB<<-rbind(optB,c(a,B2lim)) # store Bu,Bl
			} # end inirep loop 1
		ra<-which.max(optres);rc<-ceiling(ra/(L-I+1));rr<-ra-(rc-1)*(L-I+1)
		maxa<-rr+I-1 # rr (rc) is the row (col) where max(optres) lives
		step2<-trunc(step/2)
		if (step2 >=2){
			mids<-c(min(maxa+step2,L),max(maxa-step2,I))
			for(a in mids){
				B2lim<-bestb(I,L,L,a,a,nsteps,step) # find the best termveg | inirep
				optB<<-rbind(optB,c(a,B2lim)) # store Bu,Bl
				} # end mids loop
			ra<-which.max(optres);rc<-ceiling(ra/(L-I+1)); rr<-ra-(rc-1)*(L-I+1)
			maxa<-rr+I-1 # rr is the row wher max(optres) lives
			Au<-min(maxa+step2,L);Al<-max(maxa-step2,I) # set limits
			} #end if	
		#set Bu,Bl for final loop
		l1<-Au;while (is.na(match(l1,optB[,1]))){l1<-l1+1}
		l2<-Al;while (is.na(match(l2,optB[,1]))){l2<-l2-1}
		l1<-optB[match(l1,optB[,1]),2:3];l2<-optB[match(l2,optB[,1]),2:3]
		Bu<-max(l1[1],l2[1]); Bl<-min(l1[2],l2[2])
		} # end inirep loop 1
	for (a in Au:Al) { # inirep loop 2

## reducing extra in bestb() from 3 to 1 for speed.

		bestb(I,L,Bu,Bl,a,nsteps,1,1) # find the best termveg | inirep
		} # end inirep loop 2
		# calculate rc adn rr, the col and row numbers of max(optres)
	ra<-which.max(optres);rc<-ceiling(ra/(L-I+1));rr<-ra-(rc-1)*(L-I+1)
	maxa<-rr+I-1 # rr is the row wher max(optres) lives
		# store output from optallCP in vector res
	res<<-rep(0,5); res[1]<<-maxa; res[2]<<-rc+I-1
	res[3]<<-optagsen[rr,rc]; res[4]<<-max(optres, na.rm=TRUE)
	res[5]<<-optspan[rr,rc]
	names(res)<<-c("inirep","termveg","agsen","vsdC","span")
	return(res)
	} # end optCP
# -----------------
# bestc() finds the best agsen value for a given inirep and termveg value, using a 2 step search first breaking the search region into nsteps invervals, then searching the area around the step with the greatest result. If the step size is less than 2, then it just tries all values in the (a:L) range.
### are marks for changes to allow agsen to be < inirep.

bestc=function (I,L,a,b,nsteps,extra=0) {	
	Cu<-L; Cl<-I; maxc<<-rep(0,3); maxc2<<-rep(0,3) # zero out result counter
	stepc <<- trunc((p.maxtime-I)/nsteps); stepc2<-stepc #??p.maxtime not L??
	if (stepc >=2) { # course agsen loop
		restempc<-growo(I,p.maxtime,a,b,Cu) # grow from t=I to p.maxtime
		maxc[1]<<-L;maxc[2]<<-restempc[1]; itcount<<-itcount+1
		for (c in seq(L-stepc,I,-stepc)){ # test c by stepc
			restempc<-growo(min(c,restempc[2]-1),p.maxtime,a,b,c) #run model
			itcount<<-itcount+1
			if (restempc[1]>=maxc[2])
				# store if res >= res[-1]
			{maxc[1]<<-c;maxc[2]<<-restempc[1];maxc[3]<<-restempc[2]}
			} # end end test c by stepc
		Cu<-min(L,maxc[1]+stepc-1);Cl<-max(I,maxc[1]-stepc+1) # set limits
		stepc2 <- trunc(stepc/2)
		if (stepc2>=2){ 	# only if step is >6
		## find midpoints between best c value and nearest tested points
		mids<-c(min(maxc[1]+stepc2,Cu),max(maxc[1]-stepc2,Cl))
		for(c in mids){
			restempc<-growo(I,p.maxtime,a,b,c)
			itcount<<-itcount+1
			if (restempc[1]>=maxc[2])
				# store if res >= res[-1]
			{maxc[1]<<-c;maxc[2]<<-restempc[1];maxc[3]<<-restempc[2]}
			}
		Cu<-min(L,maxc[1]+stepc2+extra);Cl<-max(I,maxc[1]-stepc2-extra) # set limit
		} #end if	
		} #end course agsen loop
		restempc<-growo(I,p.maxtime,a,b,Cu) # call model
		maxc2[1]<<-Cu;maxc2[2]<<-restempc[1]; itcount<<-itcount+1
		for (c in (Cu-1):Cl){ # fine agsen loop
			restempc<-growo(min(c,restempc[2]-1),p.maxtime,a,b,c) #run model
			itcount<<-itcount+1
			if (restempc[1]>=maxc2[2])
				# store if res >= res[-1]
			{maxc2[1]<<-c;maxc2[2]<<-restempc[1];maxc2[3]<<-restempc[2]}
		} # end agsen loop
	if(maxc2[2]>maxc[2]){maxc<<-maxc2}	
	optagsen[a-I+1,b-I+1]<<-maxc[1] # store optimal c|a,b
	optres[a-I+1,b-I+1]<<-maxc[2]	  # store result  a,b,c
	optspan[a-I+1,b-I+1]<<-maxc[3]
	} # end bestc
# ----------------------------
# bestb() finds the best termveg value for a given inirep value, seraching by step, bestb() uses bestc().

bestb=function (I,L,Bu,Bl,a,nsteps,step,extra=0) {
	for (b in seq(Bu,Bl,-step)){
		bestc(I,L,a,b,nsteps,extra)
		} # end termveg loop 1
	maxb<-which.max(optres[a-I+1,])+I-1
	# if step>=2, this is a 1st loop, do the following:
	if (step >=2) { # skip this if step = 1 
		step2<-trunc(step/2); if(step2>=2){
			#check 1/2step from maxb
			mids<-c(min(maxb+step2,Bu),max(maxb-step2,Bl))
			for(b in mids){bestc(I,L,a,b,nsteps,extra)} # best c mids
			maxb<-which.max(optres[a-I+1,])+I-1
			Bu<-min(maxb+step2,Bu);Bl<-max(maxb-step2,Bl) # set Bu,Bl
			return(c(Bu,Bl))
			} # end if step2>=2
		} # end skip if stp=1
	} # end bestb

# -----------------------------
# optimize(grow,c(p.inirep,p.maxtime),maximum=FALSE,tol=0.0001)
# optim(p,grow,gr=NULL,method="L-BFGS-B",lower=c(10,0.05,10),upper=c(120,1,120))
# optimize() and optim() DON'T WORK here b/c I can't get them to treat my time variables as integer values....
# optgrid() {he.R.misc} uses an ndimensional grid seach which is slow, ineeficient, and dumb, but it seems to handle integer variables OK
# genoud() is a genetic algorithm optimizer which might work also
